<style>
    :root {
        --primary-color: #f26124;
        --secondary-color: #231f20;
        --success-green: #28a745;
        --info-blue: #17a2b8;
        --danger-red: #dc3545;
        --warning-yellow: #ffc107;
        --whatsapp-green: #25D366;
    }

    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        background: #f4f6f9;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        color: #495057;
    }

    /* Container */
    .container {
        max-width: 1200px;
        margin: 0 auto;
        padding: 0 15px;
    }

    /* Spacing */
    .py-3 {
        padding-top: 1rem !important;
        padding-bottom: 1rem !important;
    }

    .py-5 {
        padding-top: 3rem !important;
        padding-bottom: 3rem !important;
    }

    .p-4 {
        padding: 1.5rem !important;
    }

    .p-md-5 {
        padding: 3rem !important;
    }

    .mb-2 {
        margin-bottom: 0.5rem !important;
    }

    .mb-3 {
        margin-bottom: 1rem !important;
    }

    .mb-4 {
        margin-bottom: 1.5rem !important;
    }

    .me-2 {
        margin-right: 0.5rem !important;
    }

    /* Grid */
    .row {
        display: flex;
        flex-wrap: wrap;
        gap: 24px;
    }

    .col-lg-8 {
        flex: 0 0 calc(66.666% - 12px);
    }

    .col-lg-4 {
        flex: 0 0 calc(33.333% - 12px);
    }

    .col-md-6 {
        flex: 0 0 calc(50% - 12px);
    }

    /* Typography */
    h3 {
        font-size: 28px;
        font-weight: 700;
        color: #231f20;
    }

    h5 {
        font-size: 16px;
        font-weight: 700;
        color: #231f20;
    }

    p {
        font-size: 14px;
        color: #495057;
        margin: 0;
    }

    .fw-bold {
        font-weight: 700;
    }

    .text-danger {
        color: var(--danger-red) !important;
    }

    .text-success {
        color: var(--success-green) !important;
    }

    .text-white {
        color: #fff !important;
    }

    .text-center {
        text-align: center;
    }

    /* Cards */
    .card {
        background: #fff;
        border-radius: 12px;
        border: none;
        overflow: hidden;
        transition: all 0.3s ease;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    }

    .card:hover {
        box-shadow: 0 8px 16px rgba(0, 0, 0, 0.12);
        transform: translateY(-2px);
    }

    .card-body {
        padding: 1.5rem;
    }

    .border-0 {
        border: none !important;
    }

    .shadow {
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    }

    /* Alert */
    .alert {
        padding: 1rem;
        border-radius: 8px;
        border: none;
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .alert-success {
        background: #d4edda;
        color: #155724;
    }

    .alert-warning {
        background: #fff3cd;
        color: #856404;
    }

    .alert-danger {
        background: #f8d7da;
        color: #721c24;
    }

    .alert-info {
        background: #d1ecf1;
        color: #0c5460;
    }

    .alert-dismissible {
        position: relative;
        padding-right: 2.5rem;
    }

    .btn-close {
        position: absolute;
        top: 0.5rem;
        right: 0.5rem;
        background: transparent;
        border: none;
        font-size: 20px;
        cursor: pointer;
        opacity: 0.7;
        transition: opacity 0.2s;
    }

    .btn-close:hover {
        opacity: 1;
    }

    /* Forms */
    .form-label {
        font-size: 14px;
        font-weight: 600;
        color: #231f20;
        margin-bottom: 8px;
        display: block;
    }

    .form-control,
    .form-select {
        display: block;
        width: 100%;
        padding: 10px 12px;
        font-size: 14px;
        color: #495057;
        background-color: #fff;
        border: 1px solid #dee2e6;
        border-radius: 6px;
        transition: all 0.3s ease;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .form-control:focus,
    .form-select:focus {
        color: #495057;
        background-color: #fff;
        border-color: var(--primary-color);
        outline: 0;
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
    }

    .form-control::placeholder {
        color: #adb5bd;
    }

    textarea.form-control {
        resize: vertical;
        min-height: 150px;
    }

    small.text-danger {
        font-size: 12px;
        margin-top: 4px;
        display: block;
    }

    /* Buttons */
    .btn {
        font-size: 14px;
        font-weight: 600;
        padding: 10px 16px;
        border-radius: 6px;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-primary {
        background: var(--primary-color);
        color: #fff;
    }

    .btn-primary:hover {
        background: #d95520;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(242, 97, 36, 0.3);
        color: #fff;
        text-decoration: none;
    }

    .btn-light {
        background: #fff;
        color: #231f20;
        border: none;
    }

    .btn-light:hover {
        background: #f8f9fa;
        color: #231f20;
        text-decoration: none;
    }

    .btn-lg {
        padding: 12px 20px;
        font-size: 16px;
    }

    .w-100 {
        width: 100%;
    }

    /* Icons */
    i {
        margin-right: 4px;
    }

    .fa-lg {
        font-size: 1.33333333em;
        line-height: 0.75em;
        vertical-align: -0.0667em;
    }

    .fa-3x {
        font-size: 3em;
    }

    .text-primary {
        color: var(--primary-color) !important;
    }

    /* Links */
    a {
        color: var(--primary-color);
        text-decoration: none;
        transition: all 0.2s ease;
    }

    a:hover {
        color: #d95520;
        text-decoration: underline;
    }

    /* Contact Info */
    .contact-item {
        display: flex;
        align-items: center;
        gap: 12px;
        margin-bottom: 1rem;
    }

    .contact-item i {
        flex-shrink: 0;
        font-size: 1.5em;
    }

    /* Gradient Cards */
    .gradient-whatsapp {
        background: linear-gradient(135deg, #25D366, #128C7E);
    }

    .gradient-primary {
        background: linear-gradient(135deg, var(--primary-color), #8105bf);
    }

    /* Horizontal Rule */
    hr {
        border: none;
        border-top: 1px solid rgba(255, 255, 255, 0.3);
        margin: 1rem 0;
    }

    /* WhatsApp Float Button */
    .whatsapp-float {
        position: fixed;
        width: 60px;
        height: 60px;
        bottom: 40px;
        right: 40px;
        background-color: #25D366;
        color: #FFF;
        border-radius: 50%;
        text-align: center;
        font-size: 30px;
        box-shadow: 2px 2px 10px rgba(0, 0, 0, 0.3);
        z-index: 1000;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.3s ease;
        text-decoration: none;
    }

    .whatsapp-float:hover {
        background-color: #128C7E;
        transform: scale(1.1);
        box-shadow: 2px 2px 15px rgba(0, 0, 0, 0.4);
        color: #FFF;
        text-decoration: none;
    }

    .whatsapp-float i {
        margin-top: 3px;
    }

    /* Responsive */
    @media (max-width: 992px) {
        .col-lg-8 {
            flex: 0 0 100%;
        }

        .col-lg-4 {
            flex: 0 0 100%;
        }

        .row {
            gap: 16px;
        }

        .p-md-5 {
            padding: 1.5rem !important;
        }
    }

    @media (max-width: 768px) {
        .col-md-6 {
            flex: 0 0 100%;
        }

        .py-5 {
            padding-top: 2rem !important;
            padding-bottom: 2rem !important;
        }

        .card-body {
            padding: 1rem;
        }

        h3 {
            font-size: 24px;
        }

        h5 {
            font-size: 14px;
        }

        .btn-lg {
            padding: 10px 16px;
            font-size: 14px;
        }

        .whatsapp-float {
            width: 50px;
            height: 50px;
            bottom: 20px;
            right: 20px;
            font-size: 25px;
        }

        .alert {
            padding: 0.75rem;
            font-size: 13px;
        }

        .btn-close {
            top: 0.25rem;
            right: 0.25rem;
        }
    }

    @media (max-width: 576px) {
        .container {
            padding: 0 10px;
        }

        .card {
            margin-bottom: 1rem;
        }

        .card-body {
            padding: 0.75rem;
        }

        h3 {
            font-size: 20px;
        }

        h5 {
            font-size: 13px;
        }

        p {
            font-size: 13px;
        }

        .form-control,
        .form-select {
            padding: 8px 10px;
            font-size: 13px;
        }

        .btn {
            padding: 8px 12px;
            font-size: 12px;
        }

        .fa-3x {
            font-size: 2em;
        }

        .whatsapp-float {
            width: 45px;
            height: 45px;
            bottom: 15px;
            right: 15px;
            font-size: 22px;
        }
    }
</style>

<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Flash Messages -->
<?php if($this->session->flashdata('message')): ?>
    <div class="container py-3">
        <div class="alert alert-<?php echo $this->session->flashdata('message_type'); ?> alert-dismissible fade show" role="alert">
            <?php echo $this->session->flashdata('message'); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    </div>
<?php endif; ?>

<?php
// Manual WhatsApp number - Change this to your WhatsApp number
$whatsapp_number = '233593854493'; // Format: Country code + number (no + sign, spaces, or dashes)
?>

<div class="container py-5">
    <div class="row">
        <div class="col-lg-8 mb-4">
            <div class="card shadow border-0">
                <div class="card-body p-4 p-md-5">
                    <h3 class="fw-bold mb-4">Send Us a Message</h3>
                    
                    <?php echo form_open('contact/submit'); ?>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="name" value="<?php echo set_value('name'); ?>" placeholder="Your full name" required>
                                <?php echo form_error('name', '<small class="text-danger">', '</small>'); ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Email <span class="text-danger">*</span></label>
                                <input type="email" class="form-control" name="email" value="<?php echo set_value('email'); ?>" placeholder="Your email address" required>
                                <?php echo form_error('email', '<small class="text-danger">', '</small>'); ?>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Phone</label>
                                <input type="tel" class="form-control" name="phone" value="<?php echo set_value('phone'); ?>" placeholder="Your phone number">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Subject <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="subject" value="<?php echo set_value('subject'); ?>" placeholder="What is this about?" required>
                                <?php echo form_error('subject', '<small class="text-danger">', '</small>'); ?>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">Message <span class="text-danger">*</span></label>
                            <textarea class="form-control" name="message" rows="6" placeholder="Your message here..." required><?php echo set_value('message'); ?></textarea>
                            <?php echo form_error('message', '<small class="text-danger">', '</small>'); ?>
                        </div>
                        
                        <button type="submit" class="btn btn-primary btn-lg">
                            <i class="fas fa-paper-plane"></i> Send Message
                        </button>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <!-- Contact Information Card -->
            <div class="card shadow border-0 mb-4">
                <div class="card-body p-4">
                    <h5 class="fw-bold mb-3">Contact Information</h5>
                    
                    <?php if (!empty($site_settings['site_email'])): ?>
                        <div class="contact-item">
                            <i class="fas fa-envelope text-primary fa-lg"></i>
                            <a href="mailto:<?php echo $site_settings['site_email']; ?>">
                                <?php echo $site_settings['site_email']; ?>
                            </a>
                        </div>
                    <?php endif; ?>
                    
                    <?php if (!empty($site_settings['site_phone'])): ?>
                        <div class="contact-item">
                            <i class="fas fa-phone text-primary fa-lg"></i>
                            <a href="tel:<?php echo $site_settings['site_phone']; ?>">
                                <?php echo $site_settings['site_phone']; ?>
                            </a>
                        </div>
                    <?php endif; ?>
                    
                    <?php if (!empty($whatsapp_number)): ?>
                        <div class="contact-item">
                            <i class="fab fa-whatsapp text-success fa-lg"></i>
                            <a href="https://wa.me/<?php echo $whatsapp_number; ?>?text=Hello,%20I%20would%20like%20to%20get%20in%20touch" target="_blank" class="text-success">
                                +<?php echo $whatsapp_number; ?>
                            </a>
                        </div>
                    <?php endif; ?>
                    
                    <?php if (!empty($site_settings['site_address'])): ?>
                        <div class="contact-item">
                            <i class="fas fa-map-marker-alt text-primary fa-lg"></i>
                            <span><?php echo nl2br($site_settings['site_address']); ?></span>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Quick Contact via WhatsApp Card -->
            <?php if (!empty($whatsapp_number)): ?>
            <div class="card shadow border-0 mb-4 gradient-whatsapp">
                <div class="card-body p-4 text-white text-center">
                    <i class="fab fa-whatsapp fa-3x mb-3"></i>
                    <h5 class="fw-bold mb-3">Chat with us on WhatsApp</h5>
                    <p class="mb-3">Get instant responses to your queries</p>
                    <a href="https://wa.me/<?php echo $whatsapp_number; ?>?text=Hello,%20I%20would%20like%20to%20inquire%20about%20your%20services" 
                       target="_blank" 
                       class="btn btn-light btn-lg w-100">
                        <i class="fab fa-whatsapp"></i> Start WhatsApp Chat
                    </a>
                </div>
            </div>
            <?php endif; ?>
            
            <!-- Office Hours Card -->
            <div class="card shadow border-0 gradient-primary">
                <div class="card-body p-4 text-white text-center">
                    <h5 class="fw-bold mb-3">Office Hours</h5>
                    <p class="mb-2"><strong>Monday - Friday</strong></p>
                    <p class="mb-2">9:00 AM - 5:00 PM</p>
                    <hr>
                    <p class="mb-0">We typically respond within 24-48 hours</p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Floating WhatsApp Button -->
<?php if (!empty($whatsapp_number)): ?>
<a href="https://wa.me/<?php echo $whatsapp_number; ?>?text=Hello,%20I%20need%20assistance" 
   target="_blank" 
   class="whatsapp-float" 
   title="Chat on WhatsApp">
    <i class="fab fa-whatsapp"></i>
</a>
<?php endif; ?>